#include "BowerShader.h"



BowerShader::BowerShader(ID3D11Device* device, HWND hwnd) : BaseShader(device, hwnd)
{

}

BowerShader::~BowerShader()
{

}

XMMATRIX BowerShader::GetYAxisViewMatrix(Light* light)
{
	//Check and set the appropriate direction
	float yDirection = light->getDirection().y;
	yDirection > 0.0f ? yDirection = 1.0f : yDirection = -1.0f;

	XMFLOAT3 lightDirection = XMFLOAT3(0.0f, yDirection, 0.0f);
	XMFLOAT3 lightUp = XMFLOAT3(0.0f, 0.0f, 1.0f);

	//Calculate the vectors
	XMVECTOR lightPosVector = XMLoadFloat3(&light->getPosition());
	XMVECTOR lightDirectionVector = XMLoadFloat3(&lightDirection);
	XMVECTOR lightUpVector = XMLoadFloat3(&lightUp);

	//Return the matrix of the vectors
	return XMMatrixLookToLH(lightPosVector, lightDirectionVector, lightUpVector);
}
